<?php

use yii\db\Migration;

/**
 * Migration to convert `pelanggan.id` primary key into `kode_pelanggan`.
 *
 * Safety: this migration will abort if other tables have foreign keys
 * referencing `pelanggan(id)` because converting those requires
 * coordinated schema changes on referencing tables.
 */
class m251210_140000_convert_pelanggan_id_to_kode_pk extends Migration
{
    public function safeUp()
    {
        $db = $this->db->getMasterPdo();
        $schema = $this->db->schema;

        // ensure table pelanggan exists
        $tbl = $this->db->tablePrefix . 'pelanggan';
        if (!$schema->getTableSchema('pelanggan', true)) {
            echo "Table `pelanggan` does not exist. Skipping.\n";
            return true;
        }

        // check for foreign keys referencing pelanggan(id)
        $sql = "SELECT TABLE_NAME, COLUMN_NAME, CONSTRAINT_NAME FROM information_schema.KEY_COLUMN_USAGE
                WHERE REFERENCED_TABLE_NAME = 'pelanggan' AND REFERENCED_COLUMN_NAME = 'id' AND TABLE_SCHEMA = DATABASE()";
        $stmt = $db->query($sql);
        $refs = $stmt->fetchAll(PDO::FETCH_ASSOC);
        if (!empty($refs)) {
            $out = "Cannot convert primary key: other tables have foreign keys referencing pelanggan(id):\n";
            foreach ($refs as $r) {
                $out .= " - {$r['TABLE_NAME']}.{$r['COLUMN_NAME']} (constraint {$r['CONSTRAINT_NAME']})\n";
            }
            throw new \Exception($out);
        }

        // Make sure kode_pelanggan exists and is not null
        $table = $schema->getTableSchema('pelanggan');
        if (!isset($table->columns['kode_pelanggan'])) {
            throw new \Exception('Column `kode_pelanggan` does not exist on pelanggan.');
        }

        // ensure all rows have kode_pelanggan; if some are null, attempt to populate via simple generator
        $sqlNull = "SELECT COUNT(*) as cnt FROM `pelanggan` WHERE `kode_pelanggan` IS NULL OR `kode_pelanggan` = ''";
        $cnt = $db->query($sqlNull)->fetch(PDO::FETCH_ASSOC);
        if ($cnt && $cnt['cnt'] > 0) {
            echo "Found {$cnt['cnt']} rows without kode_pelanggan - generating values...\n";
            $rows = $db->query("SELECT id FROM `pelanggan` WHERE `kode_pelanggan` IS NULL OR `kode_pelanggan` = ''")->fetchAll(PDO::FETCH_ASSOC);
            // simple fallback: prefix with PLG- and incremental numbers
            $i = 1;
            foreach ($rows as $r) {
                $kode = 'PLG-' . str_pad((string)$i, 4, '0', STR_PAD_LEFT);
                $this->update('pelanggan', ['kode_pelanggan' => $kode], ['id' => $r['id']]);
                $i++;
            }
        }

        // drop any index on kode_pelanggan (we'll recreate as PK)
        $sqlIndexes = "SELECT DISTINCT INDEX_NAME FROM information_schema.STATISTICS
                       WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'pelanggan' AND COLUMN_NAME = 'kode_pelanggan'";
        try {
            $idxRows = $db->query($sqlIndexes)->fetchAll(PDO::FETCH_ASSOC);
            foreach ($idxRows as $ir) {
                $iname = $ir['INDEX_NAME'];
                if (strtoupper($iname) === 'PRIMARY') continue;
                // drop if exists
                try {
                    $this->dropIndex($iname, 'pelanggan');
                } catch (\Exception $e) {
                    // ignore individual drop errors
                }
            }
        } catch (\Exception $e) {
            // if information_schema access fails, continue — MySQL permissions might be restricted
        }

        // If `id` column exists, remove AUTO_INCREMENT (if any) and drop the column
        if (isset($table->columns['id'])) {
            try {
                $this->execute("ALTER TABLE `pelanggan` MODIFY `id` INT NULL");
            } catch (\Exception $e) {
                // ignore if modify fails
            }
            try {
                $this->execute("ALTER TABLE `pelanggan` DROP COLUMN `id`");
            } catch (\Exception $e) {
                // ignore drop errors and continue
            }
        }

        // attempt to drop existing primary key (if any) before adding new PK on kode_pelanggan
        try {
            $this->execute("ALTER TABLE `pelanggan` DROP PRIMARY KEY");
        } catch (\Exception $e) {
            // ignore - maybe no primary key or insufficient privileges
        }
        // make kode_pelanggan NOT NULL
        $this->execute("ALTER TABLE `pelanggan` MODIFY `kode_pelanggan` VARCHAR(50) NOT NULL");

        // add primary key on kode_pelanggan only if it's not already the primary key
        $sqlCheckPk = "SELECT COUNT(*) AS cnt FROM information_schema.KEY_COLUMN_USAGE
                       WHERE TABLE_SCHEMA = DATABASE() AND TABLE_NAME = 'pelanggan' AND CONSTRAINT_NAME = 'PRIMARY' AND COLUMN_NAME = 'kode_pelanggan'";
        try {
            $pkRow = $db->query($sqlCheckPk)->fetch(PDO::FETCH_ASSOC);
            $isPk = ($pkRow && isset($pkRow['cnt']) && (int)$pkRow['cnt'] > 0);
        } catch (\Exception $e) {
            $isPk = false;
        }

        if (!$isPk) {
            $this->execute("ALTER TABLE `pelanggan` ADD PRIMARY KEY (`kode_pelanggan`)");
        }

        // id column already removed earlier (if it existed)

        return true;
    }

    public function safeDown()
    {
        echo "This migration cannot be reverted automatically.\n";
        return false;
    }
}
