<?php

namespace app\controllers;

use Yii;
use app\models\Kategori;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

class KategoriController extends Controller
{
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::class,
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    public function actionIndex()
    {
        $perPage = (int)Yii::$app->request->get('per-page', 15);
        $allowed = [15,25,50,100];
        if (!in_array($perPage, $allowed)) {
            $perPage = 15;
        }
        $dataProvider = new ActiveDataProvider([
            'query' => Kategori::find(),
            'pagination' => ['pageSize' => $perPage],
        ]);

        return $this->render('index', [
            'dataProvider' => $dataProvider,
        ]);
    }

    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    public function actionCreate()
    {
        $model = new Kategori();
        
        if (Yii::$app->request->isAjax) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->asJson(['success' => true, 'id' => $model->id, 'nama' => $model->nama]);
            }
            return $this->renderAjax('_form', ['model' => $model]);
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Kategori berhasil dibuat.');
            return $this->redirect(['index']);
        }

        return $this->render('create', ['model' => $model]);
    }

    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if (Yii::$app->request->isAjax) {
            if ($model->load(Yii::$app->request->post()) && $model->save()) {
                return $this->asJson(['success' => true, 'id' => $model->id, 'nama' => $model->nama]);
            }
            return $this->renderAjax('_form', ['model' => $model]);
        }

        if ($model->load(Yii::$app->request->post()) && $model->save()) {
            Yii::$app->session->setFlash('success', 'Kategori berhasil diubah.');
            return $this->redirect(['index']);
        }

        return $this->render('update', ['model' => $model]);
    }

    public function actionDelete($id)
    {
        $this->findModel($id)->delete();
        if (Yii::$app->request->isAjax) {
            return $this->asJson(['success' => true]);
        }
        Yii::$app->session->setFlash('success', 'Kategori berhasil dihapus.');
        return $this->redirect(['index']);
    }

    /**
     * Return list of categories as JSON (id, nama)
     */
    public function actionListJson()
    {
        Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;
        return Kategori::find()->select(['id', 'nama'])->orderBy('nama')->asArray()->all();
    }

    protected function findModel($id)
    {
        if (($model = Kategori::findOne($id)) !== null) {
            return $model;
        }
        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
